﻿'-------------------------------------------------------
'     Purpose: SQLite.NET demo.
'   Attention: 1、SQLite.NET 开源软件最新版可自 http://sourceforge.net/projects/sqlite-dotnet2 下载。
'              2、SQLite.NET 安装妥当后，可使用 VS 2008 预置之 Server Explorer 建立 SQLite 库文件及 table 等对象。
'              3、SQLite.NET 当然也提供 DDL 的编码接口，但为提高生产力，建议使用 VS 2008 自带工具建立。
'              4、通过测试，发现 SQLite 非常适合作为桌面软件的数据存取引擎，是否适用于大中型纯 Db 应用需要进一步测试。
'      Author: Nosa Lee@TSSI.
'  FirstWrote: 2010/10/12
'    Modifier:
' LastUpdated: 2010/10/12
'-------------------------------------------------------


' 安装好 SQLite.NET 后引入此命名空间即可使用。
Imports System.Data.SQLite


Public Class Form1

   Private mcnn As SQLiteConnection ' SQLite 数据库连线。

   Private mcmd As SQLiteCommand    ' SQLite 命令实例。

   ' 连线到 SQLite 库，并创建 SQLiteCommand 实例。
   Private Sub btnConn_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnConn.Click
      mcnn = New SQLiteConnection("Data Source=F:\SP\VB2008\SQLite\SQLite\test.dat")
      mcnn.SetPassword("123")
      mcnn.Open()
      mcmd = mcnn.CreateCommand()
   End Sub


   ' 撷取数据。
   Private Sub btnRetrieve_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnRetrieve.Click
      mcmd.CommandText = "SELECT cNum, cStr FROM tab"
      Dim reader As SQLiteDataReader = mcmd.ExecuteReader()
      If reader.HasRows Then
         While reader.Read()
            txt.Text = txt.Text & vbCrLf & "cNum: '" & reader.GetInt16(0) & "', cStr: '" & reader.GetString(1) & "'"
         End While
      End If
      reader.Close() ' 必须关闭，否则后续的 DML 操作会出问题。
   End Sub

   ' 断开 SQLite 连线。
   Private Sub btnDisconn_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnDisconn.Click
      mcnn.Close()
   End Sub

   ' 插入数据。
   Private Sub btnInsert_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnInsert.Click
      mcmd.CommandText = "INSERT INTO tab(cNum, cStr) SELECT '3444', '" & txtInsert.Text & "'"
      mcmd.ExecuteNonQuery()
   End Sub

   ' 更新数据。
   Private Sub btnUpdate_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnUpdate.Click
      mcmd.CommandText = "UPDATE tab SET cStr = '代码插入中文（第二次修改）' WHERE cNum = 3444"
      mcmd.ExecuteNonQuery()
   End Sub

   ' 删除数据。
   Private Sub btnDel_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnDel.Click
      mcmd.CommandText = "DELETE FROM tab WHERE cNum = 3444"
      mcmd.ExecuteNonQuery()
   End Sub
End Class